function plotHandle = beamPlotCart(theta, gain)
%% beamPlotCart - Cartesian plot for beam pattern
% Basic 2D plot with several preconfigured properties.
% Returns plot handle for further extendability.

% Inputs : incident angle [rad], gain [dB]
% Outputs: plot handle
%%
% Plot data
ca = plot(rad2deg(theta), gain);
% Set properties
grid on
title('Cartesian');
xlabel('Arrival Angle (deg)');
ylabel('Gain (dB)');
% Return
plotHandle = ca;
end

